#!/usr/local/bin/perl

########################################################################
# Script to be called from cron.
# Assumes pull-summaries.pl has been run,
# so that oceana has the data from all the remote machines.
# we run an altered copy of access-summary.pl, to extricate
#  only the data we care about, and leave hostnames intact
#  (duane's version chops them in order to make readable tables).
# then filter the data by running through NDP scripts,
# ending up with OOGL and VRML files.
# autogenerate Gifs by running snapit remotely on kasina
#  (an SGI. both Irix 5.3 and Irix 6.2 should work).
# then copy files back onto oceana for inclusion in Web page.
# 
# Sun May 19 21:04:02 1996 Tamara Munzner
#
# (Note that once this has been working robustly for a while,
# we can take out some of the intermediate data files and just use
# a pipeline. It'll be easier to fix problems if we leave these
# around for now, though.)
#
# Sat Sep  7 19:28:29 1996 TMM
# update to use the latest version of the ndtools
#
########################################################################

$ENV{'TZ'} = 'PST8PDT';
require 'timelocal.pl';

# remember that $mon starts at 0, not 1!
$yestfactor = 86400;
$thetime = time;
($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdat) = 
  localtime($thetime-$yestfactor);

$max = 100000;

$debug = 0 unless $debug = $ARGV[0];

if ($ARGV[1]) {
 $yymmdd = $ARGV[1];
 $yymm = substr($yymmdd, 0, 4);
} else {
 $yymm = sprintf("%02d%02d",$year,$mon+1);
 $yymmdd = sprintf("%02d%02d%02d",$year,$mon+1,$mday);
}

if ($debug) { 
  printf "yymm is $yymm, yymmdd is $yymmdd, yesterday was $sec:$min:$hour:$mday:$mon:$year:$wday:$yday:$isdat\n"; 
}

$gdir="/usr/local/cached/Statistics/Bin/Geomview";
$ndir="/k2/Ndp";
$fdir="/O3/Web/Cache";

$tmpfile = "/usr/tmp/viz.$yymmdd";
unlink($tmpfile);

system( "cd $gdir;" );

foreach $host ("uc", "bo", "sv", "sd", "it", "pb", "dc" ) {
 $doeachhost = "\\
   $gdir/new.squid.access-summary.pl \\
    $fdir/Statistics/Data/$host.cache.nlanr.net/$yymm/access.$yymmdd \\
    > $tmpfile.$host.data; 
   $gdir/cache2edge.perl $host $max < $tmpfile.$host.data >> $tmpfile";
 print $doeachhost, "\n";
 system($doeachhost) unless $debug;
}

die "Exiting: no data to use!\n" if -z $tmpfile;

$dolocal = " 
cd $gdir; 
umask 022; 
./hostresolve.perl < $tmpfile | ./percentcolor.perl > matrix.res; 
./edge2gv.perl outstyle=oogl arcstep=16 htmldoc=http://www.nlanr.net/Cache/Wrl/$yymmdd.cache.html < matrix.res > cache.oogl; 
cp -f default.html ../../../Wrl/$yymmdd.cache.html; 
./edge2gv.perl outstyle=oogl arcstep=60 srcreach=.05 dstreach=.05 htmldoc=http://www.nlanr.net/Cache/Wrl/$yymmdd.europe.html < matrix.res > europe.oogl; 
cp -f default.html ../../../Wrl/$yymmdd.europe.html; 
ln -s cache.oogl asia.oogl; 
";

print $dolocal, "\n\n";
system($dolocal) unless $debug;


foreach $thing ("cache", "europe", "asia") {
 $dothing = " 
cd $gdir; 
umask 022;
scp $thing.oogl kasina:$ndir/snap.oogl;
scp $thing.snap.gv kasina:$ndir/frame.snap.gv;
ssh kasina \"cd $ndir; ./snapit\"; 
scp kasina:$ndir/snap.big.gif $fdir/Gif/$yymmdd.$thing.big.gif; 
scp kasina:$ndir/snap.small.gif $fdir/Gif/$yymmdd.$thing.small.gif;
/bin/rm -f $fdir/Gif/current.$thing.big.gif;
ln -s $fdir/Gif/$yymmdd.$thing.big.gif $fdir/Gif/current.$thing.big.gif;
/bin/rm -f $fdir/Gif/current.$thing.small.gif;
ln -s $fdir/Gif/$yymmdd.$thing.small.gif $fdir/Gif/current.$thing.small.gif;
";

 unless ($thing eq "asia") {
  $dothing .= " 
cd $gdir; 
umask 022; 
scp kasina:$ndir/snap.wrl $fdir/Wrl/$yymmdd.$thing.wrl; 
wrladdglobe.perl $fdir/Wrl/$yymmdd.$thing.wrl; 


cp $thing.oogl $fdir/Oogl/$yymmdd.$thing.oogl; 
/bin/rm -f $fdir/Oogl/current.$thing.oogl; 
ln -s $fdir/Oogl/$yymmdd.$thing.oogl $fdir/Oogl/current.$thing.oogl;
/bin/rm -f  $fdir/Wrl/current.$thing.wrl; 
ln -s $fdir/Wrl/$yymmdd.$thing.wrl $fdir/Wrl/current.$thing.wrl;
";
 }

 print $dothing, "\n\n";
 system($dothing) unless $debug;
}

